'''
*******************************************  UFCAL.PY  ********************************************
                 ufcal.py is a python program to calbrate ultrafast nD NMR acquisition.
                 2 points of reference are necessary for ultra-fast calibration.

                 Copy ufcal.py to TOPSPIN/exp/stan/nmr/py/user/
                 
                 Execution by topspin command:  ufcal

                 Tested with Bruker Topspin 1.3; 2.1; 3.0                                                                                                   

                 Version: 2011-01-14

                 Author: Benoit CHARRIER, Laboratoire CEISAM, Nantes
                 Mail: Benoit.Charrier@univ-nantes.fr
****************************************************************************************************
'''

from de.bruker.nmr.mfw.base import *
from de.bruker.nmr.jview.listener import *


#********************** Define class/functions  *****************************************************
class PCursor2D(Cursor2D):
	def __init__(self,view,originalCursor):
		self.wait1 = 1
		self.wait2 = 0
		self.point1 = None
		self.point2 = None
		self.v = view
		self.orig = originalCursor
		Cursor2D.__init__(self,view)
		
	def pressed(self, event):
                mapperX = self.v.getCoordinateMapper()[0]
                mapperY = self.v.getCoordinateMapper()[1]

		if self.wait1:
                        self.point1 = event.getPoint()
                        self.x1 = mapperX.mapToPhysical(self.point1.x)
                        self.y1 = mapperY.mapToPhysical(self.point1.y)
                        self.wait1=0
                
		if self.wait2:
                        self.point2 = event.getPoint()
                        self.x2 = mapperX.mapToPhysical(self.point2.x)
                        self.y2 = mapperY.mapToPhysical(self.point2.y)
                        self.wait2=0               


def msg_noND(DIM):
        ERRMSG('Current data set is a '+str(DIM)+'D acquisition data','Incorrect dimension')

def msg_nodata():
        ERRMSG('No NMR data open or selected')

def msg_cal(n,x_unit,y_unit,x,y):
        x_disp='%.4f'%x
        y_disp='%.4f'%y
        if n=='First':  button='Define a 2nd point'
        if n=='Second': button='OK'

        point=INPUT_DIALOG('2points calibration','Spectrum calibration frequency\n'+n+' point:',['F2['+x_unit+']','F1['+y_unit+']'],[x_disp,y_disp],['',''],['1','1'],[button,'Cancel'])
        if point==None: return -1
        else:
                if point[0]==x_disp: point[0]=str(x)
                if point[1]==y_disp: point[1]=str(y)
                return point[:]

def msg_invscale(dim):
        ERRMSG('scale of the '+dim+'-axis cannot be reversed!')

def exit_ufcal():
        layout.setCursorListener(oldCursor)
        SelectedIntFrame.setTitle(orig_title)
        layout.getTitle().setText('')
        EXIT()
        
#********************** Check the current dataset *****************************************************

DIM=GETACQUDIM()
if DIM==-1:
        msg_nodata()
        exit_ufcal()
if DIM==1:
        msg_noND(DIM)
        exit_ufcal()

curdata=CURDATA()
if len(curdata)==5: pathprocno=curdata[3]+'/data/'+curdata[4]+'/nmr/'+curdata[0]+'/'+curdata[1]+'/pdata/'+curdata[2]
else: pathprocno=curdata[3]+'/'+curdata[0]+'/'+curdata[1]+'/pdata/'+curdata[2]

#********************** get datas and set cursor *******************************************************
SelectedIntFrame = UtilDesktop.getDesktop().getSelectedIntFrame()
orig_title=SelectedIntFrame.getTitle()
if orig_title.count('calibration')==0: SelectedIntFrame.setTitle(orig_title+'     Two point calibration for'+chr(10)+'2D UltraFast data')

dataInfo = SelectedIntFrame.getDataObject()
allData = dataInfo.get("DATA_OBJECTS")
nmr = allData[0]
layout = nmr.getLayout()
layout.getTitle().setText('Calibration for ultrafast NMR data:'+chr(10)+'Define two points')
FullPhysicalRange=nmr.getFullPhysicalRange()
refx=FullPhysicalRange[0].getReference()
refy=FullPhysicalRange[1].getReference()
oldCursor = layout.getCursorListener()
cursor = PCursor2D(layout.getCursorHolder(),oldCursor)   #new object of PCursor2D class
layout.setCursorListener(cursor)
ax = layout.getAxes();
unit=ax[0].getUnit();

MSG('Calibration for ultrafast NMR data:'+chr(10)+'Click twice to define two points')


#********************** Wait for a cursor event to open an input dialog box ****************************

#1st point Calibration:
while cursor.wait1:
	SLEEP(0.1)

ax=layout.getAxes()
x_unit=ax[0].getUnit()
y_unit=ax[1].getUnit()

point1=msg_cal('First',x_unit,y_unit,cursor.x1,cursor.y1)
if point1==-1:exit_ufcal()

cursor.wait2 = 1
#2nd point Calibration:
while cursor.wait2:
	SLEEP(0.1)

point2=msg_cal('Second',x_unit,y_unit,cursor.x2,cursor.y2)
if point2==-1:exit_ufcal()

layout.setCursorListener(oldCursor)

#********************** Calculate new processed sweep width and new left offset*************************
X1=float(point1[0])
Y1=float(point1[1])
X2=float(point2[0])
Y2=float(point2[1])

if (cursor.x1-cursor.x2)*(X1-X2)<0 :
        msg_invscale('F2')
        exit_ufcal()

if (cursor.y1-cursor.y2)*(Y1-Y2)<0 :
        msg_invscale('F1')
        exit_ufcal()
        
ySW_p=float(GETPARSTAT('SW_p',1))
xSW_p=float(GETPARSTAT('SW_p',2))
yOFFSET=float(GETPARSTAT('OFFSET',1))
xOFFSET=float(GETPARSTAT('OFFSET',2))

YSW_p=ySW_p*(Y1-Y2)/(cursor.y1-cursor.y2)*1.0
XSW_p=xSW_p*(X1-X2)/(cursor.x1-cursor.x2)*1.0

if y_unit=='ppm': YOFFSET= (yOFFSET-cursor.y2)*YSW_p/ySW_p+Y2
else: YOFFSET= (yOFFSET-cursor.y2/refy)*YSW_p/ySW_p+Y2/refy
if x_unit=='ppm': XOFFSET= (xOFFSET-cursor.x2)*XSW_p/xSW_p+X2
else:XOFFSET= (xOFFSET-cursor.x2/refx)*XSW_p/xSW_p+X2/refx
        

#********************** Apply new processed sweep width and new left offset*****************************
XCMD('2s sw_p '+str(XSW_p))
XCMD('1s sw_p '+str(YSW_p))

XCMD('2s OFFSET '+str(XOFFSET))
XCMD('1s OFFSET '+str(YOFFSET))

#********************** Back to dataset ****************************************************************
#save calibration parameters for multiufcal
cal_str=str(XSW_p)+chr(10)+str(YSW_p)+chr(10)+str(XOFFSET)+chr(10)+str(YOFFSET)
cal_w=open(pathprocno+'/cal','w')
cal_w.write(cal_str)
cal_w.close()

XCMD('.f1r')#zoom all
XCMD('.f2r')
MSG('Calibration done')
exit_ufcal()

