'''
*******************************************  UFSYM.PY  ********************************************
                 ufsym.py is a python program to symmetrize any ultrafast nmr spectra (even interlaced).
               

                 Copy ufsym.py to TOPSPIN/exp/stan/nmr/py/user/
                 
                 Execution by topspin command:  ufsym

                 Tested with Bruker Topspin  2.1; 3.0

                 Version: 2014-01-17

                 Authors:
                        Benoit CHARRIER, Laboratoire CEISAM, Nantes (Benoit.Charrier@univ-nantes.fr)
                        Laetitia ROUGER, Laboratoire CEISAM, Nantes

                 Supervisor:
                        Patrick GIRAUDEAU,  Laboratoire CEISAM, Nantes (Patrick.Giraudeau@univ-nantes.fr)

****************************************************************************************************
'''
from de.bruker.nmr.mfw.base import UtilDesktop
from de.bruker.nmr.jview.listener import *
from de.bruker.nmr.jview.data     import PhysicalRange
import shutil
import jarray
import time
from java.lang import *
from java.awt import *
try:
        from array import * #fast run time with C-built module "array" (python 2.5.1/topspin 3.x), not implemented on python 2.1.0 (topspin 2.x)
        method=3 
except:
        import struct #read values 2rr stored in submatrix format (better than nmr.getDataDouble(IndexRange,[SIx,SIy])n linear reading)
        method=2 

#_________________________________________________CLASS & FUNCTIONS________________________________________________

class PCursor2D(Cursor2D):
	def __init__(self,view,originalCursor):
		self.working = 1;
		self.point1 = None
		self.point2 = None
		self.v = view
		self.orig = originalCursor
		Cursor2D.__init__(self,view)
	
	def repaint(self):
		# repaint the whole drawing area
		self.v.getDrawable().repaint()
		
	def moved(self, event):
		Cursor2D.moved(self,event)
		self.repaint()
		
	def pressed(self, event):
		self.point1 = event.getPoint()

        def released(self, event):
                mapperX = self.v.getCoordinateMapper()[0]
                mapperY = self.v.getCoordinateMapper()[1]
                self.x1 = mapperX.mapToPhysical(self.point1.x)
                self.y1 = mapperY.mapToPhysical(self.point1.y)
                self.x2 = mapperX.mapToPhysical(self.point2.x)
                self.y2 = mapperY.mapToPhysical(self.point2.y)
		self.working = 0;
                        
	def dragged(self, event):
		self.point2 = event.getPoint()
		self.repaint()
	
	def paint(self, diagonale, line):
		if (self.point1 != None) and (self.point2 != None):
			diagonale.setColor(Color.red)
			x1 = self.point1.x
			y1 = self.point1.y
			x2 = self.point2.x
			y2 = self.point2.y
			diagonale.drawLine(2*x1-x2,2*y1-y2,2*x2-x1,2*y2-y1)
		else: Cursor2D.paint(self,diagonale,line)

		
def check_unit():
        Axes = layout.getAxes()
        Unit_x=Axes[0].getUnit()
        Unit_y=Axes[1].getUnit()
        if Unit_x!='ppm' or Unit_y!='ppm':
                ERRMSG('Unit of F1/F2 must be in ppm')
                exit_ufsym()

def msg_noND(DIM): ERRMSG('Current data set is a '+str(DIM)+'D acquisition data','Incorrect dimension')

def msg_nodata(): ERRMSG('No NMR data open or selected')

def disp(n,e,p,d,u):
        if u=='nouser':RE([n,e,p,d],'y') #topspin 3
        else:   RE([n,e,p,d,u],'y')      #topspin 2

def exit_ufsym():
        disp(name,expno,procno,directory,user)
        #UtilDesktop.redisplayFrame(SelectedIntFrame,0)
        EXIT()

def msg_todo():
        msg='<html>The symmetrization of the UF cosy requires first to manually define a diagonal line<br><br>'
        msg+='<center><font color=\"FF0000\">Click, move and release to draw a diagonale line</font></center></html>'
        MSG(msg,'Symmetrization of UltraFast cosy')
        
def msg_sym():
        value=SELECT('Symmetrization of UltraFast cosy','Run symmetrization.\r\n\
        ',['Exit','Redraw diagonale','<html><b><font color=\"FF0000\">Do symmetrization</b></font></html>'])
        return value

def msg_done(): MSG('Symmetrization done')
        
#_________________________________________________________MAIN________________________________________________________


#********************** Check the current dataset *****************************************************
SHOW_STATUS('Checking & saving Data...')

curdata=CURDATA()
directory=curdata[3]
expno=curdata[1]
procno=curdata[2]
name=curdata[0]
if len(curdata)==5:
        xwinversion=2
        user=curdata[4]
        pathname=directory+'/data/'+user+'/nmr/'+name  #Topspin version 1.x, 2.x
else:
        xwinversion=3
        user='nouser' 
        pathname=directory+'/'+name  #Topspin version 3.x (no user)
       
pathexpno=pathname+'/'+expno
pathprocno=pathexpno+'/pdata/'+procno


DIM=GETACQUDIM()
if DIM==-1:
        msg_nodata()
        EXIT()
if DIM==1:
        msg_noND(DIM)
        EXIT()


Y=int(GETPARSTAT('XDIM',1))
X=int(GETPARSTAT('XDIM',2))
SIx=int(GETPARSTAT('SI',2))
SIy=int(GETPARSTAT('SI',1))
size=4
BYTORDP=int(GETPARSTAT('BYTORDP'))

#********************** Setup window and new cursor *******************************************************

SelectedIntFrame = UtilDesktop.getDesktop().getSelectedIntFrame()

orig_title=SelectedIntFrame.getTitle()
if orig_title.count('Symmetrization')==0: SelectedIntFrame.setTitle(orig_title+'      Symmetrization of UltraFast cosy')

dataInfo = SelectedIntFrame.getDataObject()
allData = dataInfo.get("DATA_OBJECTS")
nmr = allData[0]
'''
FullPhysicalRange=nmr.getFullPhysicalRange()
IndexRange=nmr.getIndexRange(FullPhysicalRange)
DATA=nmr.getDataDouble(IndexRange,[SIx,SIy])
'''
layout = nmr.getLayout()
layout.getTitle().setText('Symmetrization of UltraFast cosy')

oldCursor = layout.getCursorListener()
cursor = PCursor2D(layout.getCursorHolder(),oldCursor)   #new cursor


#********************** Wait for a cursor event to open an input dialog box ****************************
check_unit()
msg_todo()
layout.setCursorListener(cursor)
        
sym=1
while sym:
        while cursor.working != 0:
                time.sleep(0.1)

        choice=msg_sym()
        if choice==0: exit_ufsym()
        elif choice==1: cursor.working = 1
        elif choice==2: sym=0
check_unit()

#*************************************** symmetrization *********************************************
SHOW_STATUS('symmetrization...')

indx1=nmr.getDoubleIndexFromPhysical(cursor.x1,0)
indy1=nmr.getDoubleIndexFromPhysical(cursor.y1,1)
indx2=nmr.getDoubleIndexFromPhysical(cursor.x2,0)
indy2=nmr.getDoubleIndexFromPhysical(cursor.y2,1)

sym_str=str(indx1)+chr(10)+str(indy1)+chr(10)+str(indx2)+chr(10)+str(indy2)+chr(10)+str(SIx)+chr(10)+str(SIy)

#diagonale: y=ax+b
a=1.0*(indy1-indy2)/(indx1-indx2)
b=indy1-a*indx1

#Rectangle Area where to operate symmetrization: x_start, x_end, y_start, y_end
x_0=int(round(-b/a,0)) #intesrsect y=0
x_SIx=int(round((SIy-b)/a,0)) #intesrsect y=SIy
y_0=int(round(b,0)) #intesrsect x=0
y_SIx=int(round(a*SIx+b)) #intesrsect x=SIx

if a>0:
        if x_0>0: x_start=x_0
        else: x_start=0
        if x_SIx<SIx: x_end=x_SIx
        else: x_end=SIx
        if y_0>0: y_start=y_0
        else: y_start=0
        if y_SIx<SIy: y_end=y_SIx
        else: y_end=SIy

if a<0:
        if x_0<SIx: x_end=x_0
        else: x_end=SIx
        if x_SIx>0: x_start=x_SIx
        else: x_start=0
        if y_0<SIy: y_end=y_0
        else: y_end=SIy
        if y_SIx>0: y_start=y_SIx
        else: y_start=0


#symmetrization: keep the lowest value between each point and its image to the diagonale

K0=X*Y-X
K1=SIx*Y-X*Y
S0=indy1-a*indx1

if method==2:
        t2=time.clock()
        rr=open(pathprocno+'/2rr','rb')
        DATA_BIN=rr.read()#string of binaries
        rr.close()
        DATA_LI=[DATA_BIN[i:i+size] for i in range(0, len(DATA_BIN), size)]#list of 4*bytes packets
        if BYTORDP==0: fmt_r='<'+'i'*(SIx*SIy) #little endian:0
        else: fmt_r='>'+'i'*(SIx*SIy) #big endian:1
        DATA_VAL=struct.unpack(fmt_r, DATA_BIN) #list of integers

        for y in xrange(y_start,y_end):                
                xS=int((y-indy1)/a+indx1)
                S2=K1*int(y/Y)+X*y
                S3=K0*int(xS/X)+xS                
                for x in xrange(x_start,x_end):                        
                        yS=int(a*x+S0)
                        I=K0*int(x/X)+S2+x                        
                        IS=S3+K1*int(yS/Y)+X*yS
                        
                        if DATA_VAL[I]<DATA_VAL[IS]: DATA_LI[IS]=DATA_BIN[4*I:4*I+size]
                        else: DATA_LI[I]=DATA_BIN[4*IS:4*IS+size]

        rr_wb=open(pathprocno+'/2rr','wb')
        for element in DATA_LI: rr_wb.write(element) 
        rr_wb.close()
        t3=time.clock()
        print 'loop run time='+str(t3-t2)+'sec'

        
if method==3:
        t2=time.clock()
        rr=open(pathprocno+'/2rr','rb')
        DATA_FILE = array('i', [])

        try:
                DATA_FILE.fromfile(rr, SIx*SIy)
                rr.close()
        except EOFError:
                ERRMSG('Error reading file 2rr!')
                rr.close()
        
        if BYTORDP==0: DATA_FILE.byteswap()
        
        for y in xrange(y_start,y_end):
                xS=int((y-indy1)/a+indx1)
                S2=K1*int(y/Y)+X*y
                S3=K0*int(xS/X)+xS                
                for x in xrange(x_start,x_end):
                        yS=int(a*x+S0)
                        I=K0*int(x/X)+S2+x                        
                        IS=S3+K1*int(yS/Y)+X*yS
                        if DATA_FILE[I]<DATA_FILE[IS]:DATA_FILE[IS]=DATA_FILE[I]
                        else:DATA_FILE[I]=DATA_FILE[IS] 

        if BYTORDP==0: DATA_FILE.byteswap()
        rr_wb=open(pathprocno+'/2rr','wb')
        
        try:
                DATA_FILE.tofile(rr_wb)
                rr_wb.close()
        except EOFError:
                ERRMSG('Error writing file 2rr!')
                rr_wb.close()
        t3=time.clock()
        print 'loop run time='+str(t3-t2)+'sec'


#save symmetrysation parameters for multisym
sym_w=open(pathprocno+'/sym','w')
sym_w.write(sym_str)
sym_w.close()

# redisplay original frame,layout, cursor
layout.setCursorListener(oldCursor)
SelectedIntFrame.setTitle(orig_title)
#UtilDesktop.redisplayFrame(SelectedIntFrame,0)
disp(name,expno,procno,directory,user)
msg_done()

