/***  Auteur : David Delfieu  
      Librairie Ge4pi crée le 16/02/2021 
                      modifie et teste avec succés le 20 mai 2025 : Passe de référence externe à interne
                                        
- int lireAD7934(void)  : Lit suivant la voie le resultat de la conversion 12 bits
- void programAD7934(int voie)  : Configure l'ADC sur la voie choisie
*/
#include <Arduino.h>
#include "Ge4pi.h"
#define INT16_MAX 32767
#define INT32_MAX 2147483647
#define INT16_MIN (-32768)
#define INT32_MIN (-2147483648)

// Bits du LSB du mot de programmation de l'AD : cwrl
#define Range 0
#define Seq0 1
#define Seq1 2
#define Mod0 3
#define Mod1 4
#define ADD0 5
#define ADD1 6

// Bits du MSB du mot de programmation de l'AD : cwrH
#define REF 0
#define CODING 1

// lignes de controle de l'AD7934
#define WR 5
#define WB  4  // Word or byte
#define CS 3
#define RD 2
#define CONVST 1
#define BUSY 0

#define COURANT 0
#define VITESSE 1

int lireAD7934() {
  unsigned char l=1,H=2;
  int adr = 0, finConv = 1, IV;
  DDRA = 0x00;
  DDRC = 0x00;
  DDRL = 0x3E;
  // /CONVST
  adr = (1 << WR) + (1 << WB) + (1 << CS) + (1 << RD) + (0 << CONVST);
  PORTL = adr;

  // Attent du signal /BUSY
  do {
    finConv = PINL & 1;
  } while (finConv == 1);
  // Convstart doit durer au minimum 14 * 125 nano sec = 1,750 mus
  //l=2*l+H;
  delay(2);
//  delayMicroseconds(875);
  //v=v; //petit delai
  // /CS  /CONVST WB WR /RD
  adr = (1 << WR) + (1 << WB) + (0 << CS) + (0 << RD) + (1 << CONVST);
  PORTL = adr;

// Lecture du bus
  l = PINA;
  H = PINC & 0x0F;
  IV = l + (H<<8);
  IV &= 0x0FFF;
  IV = IV - 2047;

  // Fin du lecture : CS RD WR WB CONVST
  adr = (1 << WR) + (1 << WB) + (1 << CS) + (1 << RD) + (1 << CONVST);
  PORTL = adr;
  return (IV);
}

void programAD7934(int voie) {
// PM1 PM0 CODING REF ZERO ADD1 ADD0 MODE1 MODE0 SEQ1 SEQ0 RANGE
  int cwrH = 0, cwrL = 0, adr;
  DDRL = 0x3E;
  DDRA = 0xFF;
  DDRC = 0x0F;

  // /WR /CS WB RD CONVST
  adr = (0 << WR) + (1 << WB) + (0 << CS) + (1 << RD) + (1 << CONVST); // t4=0
  PORTL = adr;

  // envoie du mot de controle : Mod1 Mod0 = 1 0 => Differential mode 
  cwrH = (1 << REF) ; // Interne reference !! test ok le 20 mai 2025

  if (voie == COURANT) cwrL = (1 << Mod1) + (1 << Range);
  if (voie == VITESSE) cwrL = (1 << Mod1) + (1 << Range) + (1 << ADD1) ;
  
  PORTA = cwrL;
  PORTC = cwrH;

  // WR CS WB RD CONVST
  adr = (1 << WR) + (1 << WB) + (1 << CS) + (1 << RD) + (1 << CONVST); // t5=0
  PORTL = adr;
}

