/***  Auteur : David Delfieu  
      Librairie Ge4pi crée le 16/02/2021 

- Definition des valeurs maximum des INT16 et INT32
- Definition des bits du registre de controle de l'ADC 7934
- Definition des bits du bus de controle de l'ADC 7934

- int lireAD7934(void)  : Lit suivant la voie le resultat de la conversion 12 bits
- void programAD7934(int voie)  : Configure l'ADC sur la voie choisie COURANT ou VITESSE
*/

#ifndef Ge4pi
#define Ge4pi


#define INT16_MAX 32767
#define INT32_MAX 2147483647
#define INT16_MIN (-32768)
#define INT32_MIN (-2147483648)


// Bits du LSB du mot de programmation de l'AD : cwrl
#define Range 0
#define Seq0 1
#define Seq1 2
#define Mod0 3
#define Mod1 4
#define ADD0 5
#define ADD1 6

// Bits du MSB du mot de programmation de l'AD : cwrH
#define REF 0
#define CODING 1

// lignes de controle de l'AD7934
#define WR 5
#define WB  4  // Word or byte
#define CS 3
#define RD 2
#define CONVST 1
#define BUSY 0

#define COURANT 0
#define VITESSE 1


// retourne une entier sur 12 bits, resultat de la conversion sur la voie choisie par la fonction programAD6934 
int lireAD7934(void);
// Programme la voie choisie par la fonction programAD6934 
void programAD7934(int voie);
#endif
